"""
Image DPI Converter - Changes image DPI/PPI metadata
"""

from PIL import Image
import os

def convert_image_dpi(input_path, target_dpi):
    """
    Convert image to target DPI
    Returns path to converted image
    """
    try:
        # Open image
        img = Image.open(input_path)
        
        # Create output filename
        output_path = input_path.replace('uploads', 'outputs')
        output_path = output_path.rsplit('.', 1)[0] + f'_{target_dpi}dpi.' + output_path.rsplit('.', 1)[1]
        
        # Ensure output directory exists
        os.makedirs(os.path.dirname(output_path), exist_ok=True)
        
        # Save with new DPI
        img.save(output_path, dpi=(target_dpi, target_dpi))
        
        return output_path
        
    except Exception as e:
        raise Exception(f"DPI conversion failed: {str(e)}")
